/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.pmml.consumer;

import java.io.Serializable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.classifiers.AbstractClassifier;
import weka.core.Instances;
import weka.core.pmml.MappingInfo;
import weka.core.pmml.MiningSchema;
import weka.core.pmml.PMMLModel;
import weka.gui.Logger;

public abstract class PMMLClassifier
extends AbstractClassifier
implements Serializable,
PMMLModel {
    private static final long serialVersionUID = -5371600590320702971L;
    protected String m_pmmlVersion = "?";
    protected String m_creatorApplication = "?";
    protected Logger m_log = null;
    protected Instances m_dataDictionary;
    protected MiningSchema m_miningSchema;
    protected transient MappingInfo m_fieldsMap;
    protected transient boolean m_initialized = false;

    PMMLClassifier(Instances dataDictionary, MiningSchema miningSchema) {
        this.m_dataDictionary = dataDictionary;
        this.m_miningSchema = miningSchema;
    }

    @Override
    public void setPMMLVersion(Document doc) {
        String version2;
        NodeList tempL = doc.getElementsByTagName("PMML");
        Node pmml = tempL.item(0);
        if (pmml.getNodeType() == 1 && (version2 = ((Element)pmml).getAttribute("version")).length() > 0) {
            this.m_pmmlVersion = version2;
        }
    }

    @Override
    public void setCreatorApplication(Document doc) {
        String appName;
        Node app;
        NodeList appL;
        NodeList tempL = doc.getElementsByTagName("Header");
        Node header = tempL.item(0);
        if (header.getNodeType() == 1 && (appL = ((Element)header).getElementsByTagName("Application")).getLength() > 0 && (app = appL.item(0)).getNodeType() == 1 && (appName = ((Element)app).getAttribute("name")) != null && appName.length() > 0) {
            String version2 = ((Element)app).getAttribute("version");
            if (version2 != null && version2.length() > 0) {
                appName = String.valueOf(appName) + " v. " + version2;
            }
            this.m_creatorApplication = appName;
        }
    }

    public Instances getDataDictionary() {
        return this.m_dataDictionary;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return this.m_miningSchema;
    }

    @Override
    public String getPMMLVersion() {
        return this.m_pmmlVersion;
    }

    @Override
    public String getCreatorApplication() {
        return this.m_creatorApplication;
    }

    @Override
    public void setLog(Logger log) {
        this.m_log = log;
    }

    @Override
    public Logger getLog() {
        return this.m_log;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        throw new Exception("[PMMLClassifier] PMML models are pre-built and static!");
    }

    public void done() {
        this.m_initialized = false;
        this.m_fieldsMap = null;
    }

    public void mapToMiningSchema(Instances dataSet) throws Exception {
        if (this.m_fieldsMap == null) {
            this.m_fieldsMap = new MappingInfo(dataSet, this.m_miningSchema, this.m_log);
            this.m_initialized = true;
        }
    }

    public String getFieldsMappingString() {
        if (!this.m_initialized) {
            return null;
        }
        return this.m_fieldsMap.getFieldsMappingString();
    }
}

